using System;
using System.IO;
using DynaPDF;

namespace personalize
{
	class Personalize
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diCreator, "C# test application");
            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diTitle, "Editing PDF files");
            // Conversion of pages to templates is normally not required. Templates are required if
            // the page should be scaled or used multiple times in a document, e.g. as a page background.
            // See help file for further information.
            pdf.SetImportFlags(DynaPDF.TImportFlags.ifImportAll | DynaPDF.TImportFlags.ifImportAsPage);
            if (pdf.OpenImportFile("../../../test_files/taxform.pdf", DynaPDF.TPwdType.ptOpen, null) < 0)
            {
               Console.Write("Input file \"../../../test_files/taxform.pdf\" not found!\n");
               Console.Read();
               return;
            }
            pdf.ImportPDFFile(1, 1.0, 1.0);
            pdf.CloseImportFile();

            pdf.EditPage(1);
            // We use the 14 standard fonts only because they are always available. However, in a real
            // project you should use fonts which can be embedded.
            pdf.SetFont("Courier", DynaPDF.TFStyle.fsBold, 14.0, false, DynaPDF.TCodepage.cp1252);

            pdf.WriteText(72.5, 748.5, "X");
            pdf.WriteText(74.0, 701.0, "Musterstadt");
            pdf.WriteText(74.0, 677.0, "252/1062/3323");

            pdf.BeginContinueText(74.0, 628.0);
            pdf.SetLeading(24.0);
            pdf.SetCharacterSpacing(5.8);
            pdf.AddContinueText("Mustermann");
            pdf.AddContinueText("Hermann");
            pdf.AddContinueText("22021963keineKaufmann");
            pdf.AddContinueText("Musterstrae 145");
            pdf.AddContinueText("12345Musterstadt");
            pdf.SetCharacterSpacing(0.0);
            pdf.SetFont("Courier", DynaPDF.TFStyle.fsBold, 10.0, false, DynaPDF.TCodepage.cp1252);
            pdf.SetLeading(47.5);
            pdf.AddContinueText("04.05.1994");
            pdf.SetFont("Courier", DynaPDF.TFStyle.fsBold, 14.0, false, DynaPDF.TCodepage.cp1252);
            pdf.SetCharacterSpacing(5.8);
            pdf.AddContinueText("Sabine");
            pdf.AddContinueText("18121966 ev  Hausfrau");
            pdf.EndContinueText();

            pdf.WriteText(72.5, 365.0, "X");
            pdf.WriteText(396.0, 365.0, "X");

            pdf.BeginContinueText(74.0, 316.0);
            pdf.SetLeading(24.0);
            pdf.AddContinueText("2346256780     76834560");
            pdf.AddContinueText("Sparkasse Musterstadt");
            pdf.EndContinueText();

            pdf.WriteText(72.5, 269.0, "X");
            pdf.SetCharacterSpacing(0.0);
            pdf.SetFont("Courier", DynaPDF.TFStyle.fsNone, 10.0, false, DynaPDF.TCodepage.cp1252);

            pdf.WriteText(53.0, 48.0, DateTime.Now.ToString());
            pdf.SetFillColor(pdf.RGB(0xFF, 0x66, 0x66));
            pdf.SetFont("Helvetica", DynaPDF.TFStyle.fsBold, 22.0, false, DynaPDF.TCodepage.cp1252);
            pdf.WriteText(340, 70, "www.dynaforms.de");
            pdf.SetLineWidth(0.0);
            pdf.SetLinkHighlightMode(DynaPDF.THighlightMode.hmPush);
            pdf.SetAnnotFlags(DynaPDF.TAnnotFlags.afReadOnly);
            pdf.WebLink(340, 64, 204, 22, "http://www.dynaforms.de");
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
         }
         Console.Read();
		}
	}
}
